//+------------------------------------------------------------------+
//|                                         WMA Crossover Signal.mq4 |
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+

/*
  +------------------------------------------------------------------+
  | Allows you to enter two wma periods and it will then show you at |
  | Which point they crossed over. It is more usful on the shorter   |
  | periods that get obscured by the bars / candlesticks and when    |
  | the zoom level is out. Also allows you then to remove the wmas   |
  | from the chart. (wmas are initially set at 5 and 8)              |
  +------------------------------------------------------------------+
*/   
#property copyright ""
#property link      ""

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Yellow
#property indicator_color2 Magenta

double CrossUp[];
double CrossDown[];
extern int FasterWMA = 5;
extern int SlowerWMA = 8;
extern bool SoundON=false;
double alertTag;
 double control=2147483647;
 
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_ARROW, EMPTY,3);
   SetIndexArrow(0, 233);
   SetIndexBuffer(0, CrossUp);
   SetIndexStyle(1, DRAW_ARROW, EMPTY,3);
   SetIndexArrow(1, 234);
   SetIndexBuffer(1, CrossDown);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {
   int limit, i, counter;
   double fasterWMAnow, slowerWMAnow, fasterWMAprevious, slowerWMAprevious, fasterWMAafter, slowerWMAafter;
   double Range, AvgRange;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;

   limit=Bars-counted_bars;
   
   for(i = 0; i <= limit; i++) {
   
      counter=i;
      Range=0;
      AvgRange=0;
      for (counter=i ;counter<=i+9;counter++)
      {
         AvgRange=AvgRange+MathAbs(High[counter]-Low[counter]);
      }
      Range=AvgRange/10;
       
      fasterWMAnow = iMA(NULL, 0, FasterWMA, 0, MODE_LWMA, PRICE_CLOSE, i);
      fasterWMAprevious = iMA(NULL, 0, FasterWMA, 0, MODE_LWMA, PRICE_CLOSE, i+1);
      fasterWMAafter = iMA(NULL, 0, FasterWMA, 0, MODE_LWMA, PRICE_CLOSE, i-1);


      slowerWMAnow = iMA(NULL, 0, SlowerWMA, 0, MODE_LWMA, PRICE_OPEN, i);
      slowerWMAprevious = iMA(NULL, 0, SlowerWMA, 0, MODE_LWMA, PRICE_OPEN, i+1);
      slowerWMAafter = iMA(NULL, 0, SlowerWMA, 0, MODE_LWMA, PRICE_OPEN, i-1);
      
      if ((fasterWMAnow > slowerWMAnow) && (fasterWMAprevious < slowerWMAprevious) && (fasterWMAafter > slowerWMAafter)) {
         CrossUp[i] = Low[i] - Range*0.5;
      }
      else if ((fasterWMAnow < slowerWMAnow) && (fasterWMAprevious > slowerWMAprevious) && (fasterWMAafter < slowerWMAafter)) {
          CrossDown[i] = High[i] + Range*0.5;
      }
        if (SoundON==true && i==1 && CrossUp[i] > CrossDown[i] && alertTag!=Time[0]){
         Alert("WMA Cross Trend going Down on ",Symbol()," ",Period());
        alertTag = Time[0];
      }
        if (SoundON==true && i==1 && CrossUp[i] < CrossDown[i] && alertTag!=Time[0]){
       Alert("WMA Cross Trend going Up on ",Symbol()," ",Period());
        alertTag = Time[0];
        } 
  }
   return(0);
}

